VERSION 5.00
Begin VB.Form MainForm 
   AutoRedraw      =   -1  'True
   Caption         =   "Simple Interpreter"
   ClientHeight    =   6810
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8730
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   6810
   ScaleWidth      =   8730
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdExecute 
      Caption         =   "Execute"
      Enabled         =   0   'False
      Height          =   435
      Left            =   7200
      TabIndex        =   5
      Top             =   6300
      Width           =   1335
   End
   Begin VB.ListBox lstLog 
      Height          =   1020
      IntegralHeight  =   0   'False
      ItemData        =   "MainForm.frx":0000
      Left            =   120
      List            =   "MainForm.frx":0002
      TabIndex        =   2
      Top             =   5100
      Width           =   8475
   End
   Begin VB.CommandButton cmdParse 
      Caption         =   "Parse"
      Height          =   435
      Left            =   5760
      TabIndex        =   1
      Top             =   6300
      Width           =   1335
   End
   Begin VB.TextBox txtProgram 
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   4215
      Left            =   120
      MultiLine       =   -1  'True
      TabIndex        =   0
      Top             =   420
      Width           =   8475
   End
   Begin VB.CommandButton cmdShowDebug 
      Caption         =   "More"
      Height          =   435
      Left            =   120
      TabIndex        =   6
      Top             =   6300
      Width           =   1335
   End
   Begin VB.Frame frmDebug 
      Caption         =   "Debug"
      Height          =   1335
      Left            =   120
      TabIndex        =   7
      Top             =   6840
      Width           =   8535
      Begin VB.TextBox txtCommand 
         Height          =   375
         Left            =   1800
         TabIndex        =   14
         Top             =   840
         Width           =   3495
      End
      Begin VB.TextBox txtStepDelay 
         Alignment       =   1  'Right Justify
         Height          =   375
         Left            =   5520
         TabIndex        =   13
         Text            =   "0"
         Top             =   360
         Width           =   495
      End
      Begin VB.CommandButton cmdResume 
         Caption         =   "Resume"
         Height          =   375
         Left            =   7080
         TabIndex        =   12
         Top             =   375
         Width           =   1335
      End
      Begin VB.CheckBox cbSingleStep 
         Caption         =   "Single Step"
         Height          =   255
         Left            =   1800
         TabIndex        =   11
         Top             =   360
         Width           =   1455
      End
      Begin VB.CheckBox cbStepTrace 
         Caption         =   "Step Trace"
         Height          =   255
         Left            =   120
         TabIndex        =   10
         Top             =   360
         Width           =   1695
      End
      Begin VB.Label Label3 
         Caption         =   "Delay Time (Sec)"
         Height          =   375
         Left            =   3600
         TabIndex        =   9
         Top             =   360
         Width           =   1695
      End
      Begin VB.Label Label5 
         Caption         =   "Enter Command"
         Height          =   375
         Left            =   120
         TabIndex        =   8
         Top             =   870
         Width           =   1455
      End
   End
   Begin VB.Label Label2 
      Caption         =   "Program Listing"
      Height          =   255
      Left            =   120
      TabIndex        =   4
      Top             =   120
      Width           =   1755
   End
   Begin VB.Label Label1 
      Caption         =   "Program Display"
      Height          =   255
      Left            =   120
      TabIndex        =   3
      Top             =   4800
      Width           =   1755
   End
End
Attribute VB_Name = "MainForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Program As Object   'This will point to the tree created by the parser
Private Parser As New GOLDParserEngine.GOLDParser
' Window Sizing variables
Private mytx1 As Long
Private mxtx1 As Long
Private mxtx2 As Long
Private mytx2 As Long
Private mxlstb As Long
Private mtlstb As Long
Private mtcmd1 As Long
Private mtcmd2 As Long
Private mlcmd2 As Long
Private mtcmd3 As Long
Private mlcmd3 As Long
Private mtlbl1 As Long
Private mtfrmDebug As Long

' Options
Private bMore As Boolean
Private bEvent As Boolean
Private bParsedOK As Boolean
Private bEnumDone As Boolean

Private Function DoParse() As Boolean
    'This procedure starts the GOLD Parser Engine and handles each of the
    'messages it returns. Each time a reduction is made, a new instance of a
    '"Simple" object is created and stored in the parse tree. The resulting tree
    'will be a pure representation of the Simple language and will be ready to
    'implement.
    
    Dim Response As GOLDParserEngine.GPMessageConstants
    Dim Done As Boolean, Success As Boolean       'Controls when we leave the loop
    Dim Text As String, n As Integer              'Used to create pretty token lists
           
    Success = False    'Unless the program is accepted by the parser

    With Parser
        .OpenTextString txtProgram.Text
        .TrimReductions = True
                  
        Done = False
        Do Until Done
            Response = .Parse()
               
            Select Case Response
            Case gpMsgLexicalError
                Log "LEXICAL ERROR. Line " & .CurrentLineNumber & ". Cannot recognize token: " & Parser.CurrentToken.Data
                Done = True
                  
            Case gpMsgSyntaxError
                Text = ""
                For n = 0 To Parser.TokenCount - 1
                    Text = Text & " " & Parser.Tokens(n).Name
                Next
                Log "SYNTAX ERROR. Line " & .CurrentLineNumber & ". Expecting: " & LTrim(Text)
                Done = True
              
            Case gpMsgReduction
                '== Create a new customized object and replace the
                '== CurrentReduction with it. This saves memory and allows
                '== easier interpretation
                Set .CurrentReduction = NewSimpleObject(.CurrentReduction)
                
            Case gpMsgAccept
                '=== Success!
                Set Program = .CurrentReduction
                
                Log "-- Program Accepted --"
                Done = True
                Success = True
              
            Case gpMsgTokenRead
                '=== Do nothing
               
            Case gpMsgInternalError
                Log "INTERNAL ERROR! Something is horribly wrong"
                Done = True
               
            Case gpMsgNotLoadedError
                '=== Due to the if-statement above, this case statement should never be true
                Log "NOT LOADED ERROR! Compiled Grammar Table not loaded"
                Done = True
              
            Case gpMsgCommentError
                Log "COMMENT ERROR! Unexpected end of file"
                Done = True
            End Select
            
        Loop
    End With
    DoParse = Success
End Function

Public Sub Log(ByVal Text As String)
   lstLog.AddItem Text
   Me.Refresh
End Sub

Private Sub cmdExecute_Click()
    cmdParse.Enabled = False
    cmdExecute.Enabled = False
    If bParsedOK Then
        Program.Execute
        Call Debugger.TraceMessage(gblLineNo, gblListNo, "End")
    End If
    cmdParse.Enabled = False
    cmdExecute.Enabled = True
    Log "-- Program Executed --"
End Sub

Private Sub cmdParse_Click()
    lstLog.Clear
    gblLineNo = 0
    gblListNo = 0
    gblListing = ""
    Set Program = Nothing
    bParsedOK = DoParse
    bEnumDone = False
    
    If bParsedOK Then
        If Not bEnumDone Then
            Debugger.Init
            Program.Enumerate 'Assign Line No
            txtProgram.Text = Debugger.Listing
            txtProgram.Refresh
            bEnumDone = True
        End If
        cmdParse.Enabled = False
        cmdExecute.Enabled = True
    End If
End Sub

Private Sub cmdResume_Click()
   Debugger.ResumeEvent = True
End Sub

Private Sub cmdShowDebug_Click()
    bMore = Not bMore
    bEvent = True
    If (Me.WindowState = vbMinimized) Then Exit Sub
    If bMore Then
        Me.cmdShowDebug.Caption = "Less"
        Me.Height = Me.Height + 1440
    Else
        Me.cmdShowDebug.Caption = "More"
        Me.Height = Me.Height - 1440
        Debugger.DebugMode = False
        cbStepTrace.Value = False
        Debugger.SingleStepMode = False
        cbSingleStep.Value = False
    End If
End Sub

Private Sub cbStepTrace_Click()
    Debugger.DebugMode = cbStepTrace.Value
End Sub

Private Sub cbSingleStep_Click()
    Debugger.SingleStepMode = cbSingleStep.Value
End Sub

Private Sub Form_Load()
    mxtx1 = Me.ScaleWidth - txtProgram.Width
    mytx1 = Me.ScaleHeight - txtProgram.Height
    mxlstb = Me.ScaleWidth - lstLog.Width
    mtlstb = Me.ScaleHeight - lstLog.Top
    mtcmd1 = Me.ScaleHeight - cmdShowDebug.Top
    mtcmd2 = Me.ScaleHeight - cmdParse.Top
    mlcmd2 = Me.ScaleWidth - cmdParse.Left
    mtcmd3 = Me.ScaleHeight - cmdExecute.Top
    mlcmd3 = Me.ScaleWidth - cmdExecute.Left
    mtlbl1 = Me.ScaleHeight - Label1.Top
    mtfrmDebug = Me.ScaleHeight - frmDebug.Top
    
    If Not Parser.LoadCompiledGrammar(App.Path & "\" & sCGTfilename) Then
        MsgBox "The " & sCGTfilename & " CGT file could not be opened!", vbCritical
    End If
    'Step timer to slow things down in debug trace mode
    txtStepDelay = Format(SLEEP_INTERVAL / 1000) 'Sec
    'Set commands
    cmdParse.Enabled = False
    cmdExecute.Enabled = False
    cmdShowDebug.Enabled = True
End Sub

Private Sub Form_Resize()
    ' Close More area if resize is real
    If (bMore And Not bEvent) Then
        Call cmdShowDebug_Click
    End If
    ' Reset the components to the right size.
    If Not (Me.WindowState = vbMinimized) And Not bEvent Then
        txtProgram.Width = Me.ScaleWidth - mxtx1
        txtProgram.Height = Me.ScaleHeight - mytx1
        lstLog.Width = Me.ScaleWidth - mxlstb
        lstLog.Top = Me.ScaleHeight - mtlstb
        cmdShowDebug.Top = Me.ScaleHeight - mtcmd1
        cmdParse.Top = Me.ScaleHeight - mtcmd2
        cmdParse.Left = Me.ScaleWidth - mlcmd2
        cmdExecute.Top = Me.ScaleHeight - mtcmd3
        cmdExecute.Left = Me.ScaleWidth - mlcmd3
        Label1.Top = Me.ScaleHeight - mtlbl1
        frmDebug.Top = Me.ScaleHeight - mtfrmDebug
    End If
    
    bEvent = False
End Sub

Private Sub txtCommand_KeyPress(KeyAscii As Integer)
    If KeyAscii = 13 Then
        Call Debugger.ProcessCommand(txtCommand.Text)
        txtCommand.Text = ""
        txtCommand.Refresh
    End If
End Sub

Private Sub txtProgram_Change()
   cmdExecute.Enabled = False
   cmdParse.Enabled = True
   bEnumDone = False
End Sub

Private Sub txtStepDelay_Change()
    On Error Resume Next
    Debugger.StepDelay = SLEEP_INTERVAL 'msec
    If Len(txtStepDelay.Text) > 0 Then
       Debugger.StepDelay = 1000 * CDbl(txtStepDelay.Text) 'Sec
    End If
End Sub

Public Sub Highlight_Line(iStart As Integer, iLength As Integer)
    txtProgram.SetFocus
    txtProgram.SelStart = iStart
    txtProgram.SelLength = iLength
    txtProgram.Refresh
    Debugger.GoToDelay
End Sub

Public Sub WaitForResume()
    Me.cmdResume.Enabled = True
    Me.Refresh
    Debugger.GoToSleep
    Me.cmdResume.Enabled = False
    Me.Refresh
End Sub


