Attribute VB_Name = "SimpleModule"
Option Explicit

Public Const sCGTfilename As String = "Simple 3.cgt"

Public Debugger As New SimpleDebugger
Public gblLineNo As Integer
Public gblListNo As Integer
Public gblListing As String
Public gblIndentLvl As Integer
Public Const gblIndentAmt As Integer = 3

Public Variables As New VariableList

Public Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)
Public Const SLEEP_INTERVAL As Long = 500

Public Function NewSimpleObject(TheReduction As GOLDParserEngine.Reduction) As Object
    Dim sTemp As String

    With TheReduction
        Select Case .ParentRule.TableIndex
        Case Rule_Statements                 ' <Statements> ::= <Statement> <Statements>
            Set NewSimpleObject = New SimpleStmList
            Call NewSimpleObject.Init(.Tokens(0).Data, .Tokens(1).Data)
        
        Case Rule_Statements2                ' <Statements> ::= <Statement>
            Set NewSimpleObject = New SimpleStmList
            Call NewSimpleObject.Init(.Tokens(0).Data)
        
        Case Rule_Statement_Display          ' <Statement> ::= display <Expression>
            Set NewSimpleObject = New SimpleDisplayStm
            Call NewSimpleObject.Init(.Tokens(1).Data)
        
        Case Rule_Statement_Display_Read_Id  ' <Statement> ::= display <Expression> read Id
            Set NewSimpleObject = New SimpleDisplayStm
            Call NewSimpleObject.Init(.Tokens(1).Data, .Tokens(3).Data)
        
        Case Rule_Statement_Assign_Id_Eq     ' <Statement> ::= assign Id = <Expression>
            Set NewSimpleObject = New SimpleAssignStm
            Call NewSimpleObject.Init(.Tokens(1).Data, .Tokens(3).Data)
                
        Case Rule_Statement_While_Do_End     ' <Statement> ::= while <Expression> do <Statements> end
            Set NewSimpleObject = New SimpleWhileStm
            Call NewSimpleObject.Init(.Tokens(1).Data, .Tokens(3).Data)
            
        Case Rule_Statement_If_Then_End      ' <Statement> ::= if <Expression> then <Statements> end
            Set NewSimpleObject = New SimpleIfStm
            Call NewSimpleObject.Init(.Tokens(1).Data, .Tokens(3).Data)
        
        Case Rule_Statement_If_Then_Else_End ' <Statement> ::= if <Expression> then <Statements> else <Statements> end
            Set NewSimpleObject = New SimpleIfStm
            Call NewSimpleObject.Init(.Tokens(1).Data, .Tokens(3).Data, .Tokens(5).Data)
                            
        Case Rule_Expression_Gt, Rule_Expression_Lt, Rule_Expression_Lteq, Rule_Expression_Gteq, _
            Rule_Expression_Eqeq, Rule_Expression_Ltgt, Rule_Addexp_Plus, Rule_Addexp_Minus, _
            Rule_Addexp_Amp, Rule_Multexp_Times, Rule_Multexp_Div
             
            Set NewSimpleObject = New SimpleEquation
            Call NewSimpleObject.Init(.Tokens(0).Data, .Tokens(1).Data, .Tokens(2).Data)
             
        '=== Since TrimReductions is set to true, none of these reductions will be
        '=== returned. They are performed 'behind the scenes'
        'Case Rule_Expression          ' <Expression> ::= <Add Exp>
        'Case Rule_AddExp              ' <Add Exp> ::= <Mult Exp>
        'Case Rule_MultExp             ' <Mult Exp> ::= <Negate Exp>
        'Case Rule_Negateexp           ' <Negate Exp> ::= <Value>
        
        Case Rule_Value_Id                   ' <Value> ::= Id
            Variables.Add .Tokens(0).Data
            Set NewSimpleObject = New SimpleID
            Call NewSimpleObject.Init(.Tokens(0).Data)
            
        Case Rule_Value_Stringliteral        ' <Value> ::= StringLiteral
            sTemp = .Tokens(0).Data
            If Len(sTemp) >= 2 Then           'Remove single quotes
                sTemp = Mid(sTemp, 2, Len(sTemp) - 2)
            End If
        
            Set NewSimpleObject = New SimpleString
            Call NewSimpleObject.Init(sTemp)
            
        Case Rule_Value_Numberliteral        ' <Value> ::= NumberLiteral
            Set NewSimpleObject = New SimpleNumber
            Call NewSimpleObject.Init(Val(.Tokens(0).Data))
            
        Case Rule_Value_Lparan_Rparan        ' <Value> ::= '(' <Expression> ')'
            Set NewSimpleObject = New SimpleExpression
            Call NewSimpleObject.Init(.Tokens(1).Data)
      
        End Select
                
    End With

End Function


