Attribute VB_Name = "SimpleConstants"
Public Enum SymbolConstants
   Symbol_Eof = 0             ' (EOF)
   Symbol_Error = 1           ' (Error)
   Symbol_Whitespace = 2      ' (Whitespace)
   Symbol_Minus = 3           ' '-'
   Symbol_Amp = 4             ' '&'
   Symbol_Lparan = 5          ' '('
   Symbol_Rparan = 6          ' ')'
   Symbol_Times = 7           ' '*'
   Symbol_Div = 8             ' '/'
   Symbol_Plus = 9            ' '+'
   Symbol_Lt = 10             ' '<'
   Symbol_Lteq = 11           ' '<='
   Symbol_Ltgt = 12           ' '<>'
   Symbol_Eq = 13             ' '='
   Symbol_Eqeq = 14           ' '=='
   Symbol_Gt = 15             ' '>'
   Symbol_Gteq = 16           ' '>='
   Symbol_Assign = 17         ' assign
   Symbol_Display = 18        ' display
   Symbol_Do = 19             ' do
   Symbol_Else = 20           ' else
   Symbol_End = 21            ' end
   Symbol_Id = 22             ' Id
   Symbol_If = 23             ' if
   Symbol_Numberliteral = 24  ' NumberLiteral
   Symbol_Read = 25           ' read
   Symbol_Stringliteral = 26  ' StringLiteral
   Symbol_Then = 27           ' then
   Symbol_While = 28          ' while
   Symbol_Addexp = 29         ' <Add Exp>
   Symbol_Expression = 30     ' <Expression>
   Symbol_Multexp = 31        ' <Mult Exp>
   Symbol_Statement = 32      ' <Statement>
   Symbol_Statements = 33     ' <Statements>
   Symbol_Value = 34          ' <Value>
End Enum

Public Enum RuleConstants
   Rule_Statements = 0                   ' <Statements> ::= <Statement> <Statements>
   Rule_Statements2 = 1                  ' <Statements> ::= <Statement>
   Rule_Statement_Display = 2            ' <Statement> ::= display <Expression>
   Rule_Statement_Display_Read_Id = 3    ' <Statement> ::= display <Expression> read Id
   Rule_Statement_Assign_Id_Eq = 4       ' <Statement> ::= assign Id '=' <Expression>
   Rule_Statement_While_Do_End = 5       ' <Statement> ::= while <Expression> do <Statements> end
   Rule_Statement_If_Then_End = 6        ' <Statement> ::= if <Expression> then <Statements> end
   Rule_Statement_If_Then_Else_End = 7   ' <Statement> ::= if <Expression> then <Statements> else <Statements> end
   Rule_Expression_Gt = 8                ' <Expression> ::= <Expression> '>' <Add Exp>
   Rule_Expression_Lt = 9                ' <Expression> ::= <Expression> '<' <Add Exp>
   Rule_Expression_Lteq = 10             ' <Expression> ::= <Expression> '<=' <Add Exp>
   Rule_Expression_Gteq = 11             ' <Expression> ::= <Expression> '>=' <Add Exp>
   Rule_Expression_Eqeq = 12             ' <Expression> ::= <Expression> '==' <Add Exp>
   Rule_Expression_Ltgt = 13             ' <Expression> ::= <Expression> '<>' <Add Exp>
   Rule_Expression = 14                  ' <Expression> ::= <Add Exp>
   Rule_Addexp_Plus = 15                 ' <Add Exp> ::= <Add Exp> '+' <Mult Exp>
   Rule_Addexp_Minus = 16                ' <Add Exp> ::= <Add Exp> '-' <Mult Exp>
   Rule_Addexp_Amp = 17                  ' <Add Exp> ::= <Add Exp> '&' <Mult Exp>
   Rule_Addexp = 18                      ' <Add Exp> ::= <Mult Exp>
   Rule_Multexp_Times = 19               ' <Mult Exp> ::= <Mult Exp> '*' <Value>
   Rule_Multexp_Div = 20                 ' <Mult Exp> ::= <Mult Exp> '/' <Value>
   Rule_Multexp = 21                     ' <Mult Exp> ::= <Value>
   Rule_Value_Id = 22                    ' <Value> ::= Id
   Rule_Value_Stringliteral = 23         ' <Value> ::= StringLiteral
   Rule_Value_Numberliteral = 24         ' <Value> ::= NumberLiteral
   Rule_Value_Lparan_Rparan = 25         ' <Value> ::= '(' <Expression> ')'
End Enum

