VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "SimpleDebugger"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private bDebugMode As Boolean
Private bSingleStepMode As Boolean
Private bResumeEvent As Boolean
Private iCurrentListNo As Integer
Private dStepDelay As Double
Private vlBreakPoints As New VariableList

Private Type ListNoType
   iListNo As Integer
   iStartPtr As Integer
   iLineLen As Integer
End Type

Private ListIndex() As ListNoType
Private iIndentLvl As Integer
Private sListing As String

Public Sub Init()
    sListing = ""
    ReDim ListIndex(1 To 1)
    iCurrentListNo = 0
End Sub

Public Property Let ListIndexAdd(Value As Integer)
  iCurrentListNo = Value
  ReDim Preserve ListIndex(1 To iCurrentListNo)
  ListIndex(iCurrentListNo).iListNo = Value
End Property

Public Property Get StartPtr() As Integer
  StartPtr = ListIndex(iCurrentListNo).iStartPtr
End Property

Public Sub LetStartPtr()
  ListIndex(iCurrentListNo).iStartPtr = Len(sListing)
End Sub

Public Property Get LineLen() As Integer
  LineLen = ListIndex(iCurrentListNo).iLineLen
End Property

Public Sub LetLineLen()
  ListIndex(iCurrentListNo).iLineLen = Len(sListing) - ListIndex(iCurrentListNo).iStartPtr
End Sub

Public Property Let CurrentListNo(Value As Integer)
  iCurrentListNo = Value
End Property

Public Property Get Listing() As String
  Listing = sListing
End Property
Public Property Let Listing(sText As String)
  sListing = sText
End Property

Public Sub ListingAdd(sText As String)
    sListing = sListing & sText
End Sub

Public Property Get DebugMode() As Boolean
  DebugMode = bDebugMode
End Property

Public Property Let DebugMode(Value As Boolean)
  bDebugMode = Value
End Property

Public Property Get SingleStepMode() As Boolean
  SingleStepMode = bSingleStepMode
End Property

Public Property Let SingleStepMode(Value As Boolean)
  bSingleStepMode = Value
End Property

Public Property Get StepDelay() As Double
  StepDelay = dStepDelay
End Property

Public Property Let StepDelay(Value As Double)
  dStepDelay = Value
End Property

Public Property Get ResumeEvent() As Boolean
  ResumeEvent = bResumeEvent
End Property

Public Property Let ResumeEvent(Value As Boolean)
  bResumeEvent = Value
End Property

Public Property Get IndentLvl()
  IndentLvl = iIndentLvl
End Property
Public Sub LvlIndent()
    iIndentLvl = iIndentLvl + 1
End Sub
Public Sub LvlOutdent()
    iIndentLvl = iIndentLvl - 1
End Sub

Public Sub TraceMessage(iLineNo As Integer, iListNo As Integer, sStmName As String)
    iCurrentListNo = iListNo
    If bDebugMode Then
        Debug.Print "Executing Line " & Format(iLineNo, "0000"), "Statement Type -> "; sStmName
        MainForm.Highlight_Line Me.StartPtr, Me.LineLen
        If Not bSingleStepMode Then
            Call CheckBP(iLineNo)
        End If
    End If
End Sub

Public Sub SingleStep(iLineNo As Integer)
    If bSingleStepMode Then
        MainForm.Log "Paused on Line " & Format(iLineNo, "0000")
        MainForm.Highlight_Line Me.StartPtr, Me.LineLen
        MainForm.WaitForResume
    End If
End Sub

Private Sub CheckBP(iLineNo As Integer)
    Dim i As Integer
    For i = 1 To vlBreakPoints.Count
        If vlBreakPoints.ValueByIndex(i - 1) = iLineNo Then
            MainForm.Log "Paused on Line " & Format(iLineNo, "0000")
            MainForm.WaitForResume
        End If
    Next
End Sub

Public Sub GoToSleep()
    Do While Not bResumeEvent
        Sleep 100
        DoEvents
    Loop
    bResumeEvent = False
End Sub

Public Sub GoToDelay()
    Sleep dStepDelay
    DoEvents
End Sub

Public Sub ProcessCommand(sCommand As String)
    Dim iTemp1 As Integer, iTemp2 As Integer
    Dim sOperator As String, sOperand As String, sValue As String
    If Len(sCommand) > 0 Then
        iTemp1 = InStr(1, sCommand, " ")
        iTemp2 = InStr(1, sCommand, "=")
        If iTemp1 = 0 Then
            sOperator = UCase(sCommand)
        Else
            sOperator = UCase(Left(sCommand, iTemp1 - 1))
        End If
        If sOperator = "WTV" Then
            sOperand = Trim(Mid(sCommand, iTemp1 + 1, iTemp2 - iTemp1 - 1))
            sValue = Trim(Mid(sCommand, iTemp2 + 1))
        Else
            sOperand = Mid(sCommand, iTemp1 + 1)
        End If
        
        Select Case sOperator
        
            Case "SBP"      'Set Break Point (ex. SBP xxx)
                vlBreakPoints.Add sOperator & sOperand, CStr(sOperand)
                MainForm.Log "DEBUG: Set breakpoint at line " & CStr(sOperand)
            
            Case "CBP"      'Clear Break Point (ex. CBP xxx)
                vlBreakPoints.Value("SBP" & sOperand) = ""
                MainForm.Log "DEBUG: Cleared breakpoint at line " & CStr(sOperand)
            
            Case "CAB"     ' Clear all break points
                vlBreakPoints.ClearValues
                MainForm.Log "DEBUG: Cleared all breakpoints"
                
            Case "RDV"       ' Read variable (ex. RDV ABC)
                If Variables.Count > 0 Then
                    Debug.Print sOperand & " = " & Variables.Value(sOperand)
                    MainForm.Log "DEBUG: Read " & sOperand & " as " & Variables.Value(sOperand)
                End If
                
            Case "WTV"       ' Write variable (ex. WTV ABC = 10)
                If Variables.Count > 0 Then
                    Variables.Value(sOperand) = sValue
                    MainForm.Log "DEBUG: Set " & sOperand & " to " & sValue
                End If
                
            Case Else   ' Unknown command
                MsgBox "SYNTAX:" & vbCrLf & _
                            "SBP xx,  Set Breakpoint to xx" & vbCrLf & _
                            "CBP xx,  Clear Breakpoint at xx" & vbCrLf & _
                            "CAB,     Clear All Breakpoints" & vbCrLf & _
                            "RDV aaa, Read Variable aaa" & vbCrLf & _
                            "WTV aaa = xx, Write xxx to Variable aaa", _
                            vbOKOnly, "Debug Help"
        End Select
    End If
      
End Sub

