VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "SimpleDisplayStm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public DisplayClause As Object
Public ReadID As String
Public iLineNo As Integer
Public iListNo As Integer
Public StmType As String
Public StmName As String

Private Sub Class_Initialize()
  StmName = "Display"
  StmType = "Procedural"
End Sub

Public Sub Init(oDisplayClause As Object, Optional sReadID As String = "")
    Set DisplayClause = oDisplayClause
    ReadID = sReadID
End Sub

Public Sub Execute()
    Call Debugger.TraceMessage(iLineNo, iListNo, StmName)
    Call Debugger.SingleStep(iLineNo)
    If ReadID = "" Then   'No variables accepted
        MainForm.Log DisplayClause.Value
    Else
        Variables.Value(ReadID) = InputBox(DisplayClause.Value)
    End If
End Sub

Public Sub Enumerate()
    gblLineNo = gblLineNo + 1
    gblListNo = gblListNo + 1
    iLineNo = gblLineNo
    iListNo = gblListNo
    Call AppendList
End Sub

Public Sub AppendList()
    With Debugger
        .ListIndexAdd = iListNo ' Add List No
        .LetStartPtr
        .ListingAdd Format(iLineNo, "0000 ")
        .ListingAdd Space(.IndentLvl * gblIndentAmt)
        If ReadID = "" Then   'No variables accepted
            .ListingAdd "DISPLAY " & DisplayClause.Flush & vbCrLf
        Else
            .ListingAdd "DISPLAY " & DisplayClause.Flush & " READ " & ReadID & vbCrLf
        End If
        .LetLineLen
    End With
End Sub
