VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "SimpleEquation"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public LeftOperand As Object
Public Operator As String
Public RightOperand As Object
Public iLineNo As Integer
Public StmType As String
Public StmName As String

Private Sub Class_Initialize()
  StmName = "Equation"
  StmType = "Equation"
End Sub

Private Sub Class_Terminate()
    Set LeftOperand = Nothing
    Set RightOperand = Nothing
End Sub

Public Sub Init(oLeftOperand As Object, sOperator As String, oRightOperand As Object)
    Set LeftOperand = oLeftOperand
    Operator = sOperator
    Set RightOperand = oRightOperand
End Sub

Private Function BoolVal(Value As Boolean) As String
    If Value Then
        BoolVal = "True"
    Else
        BoolVal = "False"
    End If
End Function

Public Function Value() As Variant
    Dim LValue As Variant, RValue As Variant
        
    LValue = LeftOperand.Value
    RValue = RightOperand.Value

    Select Case Operator
    Case "+"
        Value = Val(LValue) + Val(RValue)
    Case "-"
        Value = Val(LValue) - Val(RValue)
    Case "&"
        Value = CStr(LValue) & CStr(RValue)
    Case "*"
        Value = Val(LValue) * Val(RValue)
    Case "/"
        Value = Val(LValue) / Val(RValue)
    Case ">"
        Value = BoolVal(Val(LValue) > Val(RValue))
    Case "<"
        Value = BoolVal(Val(LValue) < Val(RValue))
    Case "<="
        Value = BoolVal(Val(LValue) <= Val(RValue))
    Case ">="
        Value = BoolVal(Val(LValue) >= Val(RValue))
        
    Case "=="
        If VarType(LValue) = vbString And VarType(RValue) = vbString Then
            Value = UCase(LValue) = UCase(RValue)         '== Compare strings
        Else
            Value = BoolVal(Val(LValue) = Val(RValue))    '== Compare values
        End If
        
    Case "<>"
        If VarType(LValue) = vbString And VarType(RValue) = vbString Then
            Value = UCase(LValue) <> UCase(RValue)        '== Compare strings
        Else
            Value = BoolVal(Val(LValue) <> Val(RValue))   '== Compare values
        End If

    End Select
    
End Function

Public Static Function Flush() As Variant
    If Not LeftOperand Is Nothing Then
        Flush = Flush & CStr(LeftOperand.Flush)
    End If
    If Not RightOperand Is Nothing Then
        Flush = Flush & " " & Operator & " " & CStr(RightOperand.Flush)
    End If
End Function


