VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "SimpleIfStm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public IfClause As Object
Public ThenClause As Object
Public ElseClause As Object
Public iThenLineNo As Integer
Public iElseLineNo As Integer
Public iThenListNo As Integer
Public iElseListNo As Integer
Public iEndListNo As Integer
Public StmType As String
Public StmName As String

Private Sub Class_Initialize()
  StmName = "If"
  StmType = "Decision"
End Sub

Private Sub Class_Terminate()
    Set IfClause = Nothing
    Set ThenClause = Nothing
    Set ElseClause = Nothing
End Sub

Public Sub Init(oIfClause As Object, oThenClause As Object, Optional oElseClause As Object = Nothing)
    Set IfClause = oIfClause
    Set ThenClause = oThenClause
    If Not oElseClause Is Nothing Then
        Set ElseClause = oElseClause
    End If
End Sub

Public Sub Execute()
    Call Debugger.TraceMessage(iThenLineNo, iThenListNo, "If Then")
    Call Debugger.SingleStep(iThenLineNo)
    If IfClause.Value = "True" Then
        ThenClause.Execute
    Else
        If Not ElseClause Is Nothing Then
            Call Debugger.TraceMessage(iElseLineNo, iElseListNo, "Else")
            Call Debugger.SingleStep(iElseLineNo)
            ElseClause.Execute
        End If
    End If
End Sub

Public Sub Enumerate()
    gblLineNo = gblLineNo + 1
    gblListNo = gblListNo + 1
    iThenLineNo = gblLineNo
    iThenListNo = gblListNo
    Call AppendList(1)
    ThenClause.Enumerate
    If Not ElseClause Is Nothing Then
        gblListNo = gblListNo + 1 'Skip Else statement
        iElseLineNo = gblLineNo
        iElseListNo = gblListNo
        Call AppendList(2)
        ElseClause.Enumerate
    End If
    gblListNo = gblListNo + 1 'Skip End statement
    iEndListNo = gblListNo
    Call AppendList(3)
End Sub

Public Sub AppendList(iStage As Integer)

    With Debugger
        Select Case iStage
        Case 1:
            .ListIndexAdd = iThenListNo ' Add Line no
            .LetStartPtr
            .ListingAdd Format(iThenLineNo, "0000 ")
            .ListingAdd Space(.IndentLvl * gblIndentAmt)
            .ListingAdd "IF " & IfClause.Flush & " THEN" & vbCrLf
            .LvlIndent
            .LetLineLen
        Case 2:
            .ListIndexAdd = iElseListNo ' Add Line no
            .LetStartPtr
            .LvlOutdent
            .ListingAdd "     "         ' No Line No
            .ListingAdd Space(.IndentLvl * gblIndentAmt)
            .ListingAdd "ELSE" & vbCrLf
            .LvlIndent
            .LetLineLen
            
        Case 3:
            .ListIndexAdd = iEndListNo ' Add Line no
            .LetStartPtr
            .LvlOutdent
            .ListingAdd "     "        ' No Line No
            .ListingAdd Space(.IndentLvl * gblIndentAmt)
            .ListingAdd "END" & vbCrLf
            .LetLineLen
        End Select
    End With
End Sub

