VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "SimpleWhileStm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public WhileClause As Object
Public DoClause As Object
Public iWhileLineNo As Integer
Public iWhileListNo As Integer
Public iEndListNo As Integer
Public StmType As String
Public StmName As String

Private Sub Class_Initialize()
  StmName = "While"
  StmType = "Iteration"
End Sub

Private Sub Class_Terminate()
    Set WhileClause = Nothing
    Set DoClause = Nothing
End Sub

Public Sub Init(oWhileClause As Object, oDoClause As Object)
    Set WhileClause = oWhileClause
    Set DoClause = oDoClause
End Sub

Public Sub Execute()
    Call Debugger.TraceMessage(iWhileLineNo, iWhileListNo, StmName)
    Call Debugger.SingleStep(iWhileLineNo)

    Do While WhileClause.Value = "True"
        DoClause.Execute
    Loop
End Sub

Public Sub Enumerate()
    gblLineNo = gblLineNo + 1
    gblListNo = gblListNo + 1
    iWhileLineNo = gblLineNo
    iWhileListNo = gblListNo
    Call AppendList(1)
    DoClause.Enumerate
    gblListNo = gblListNo + 1 'Skip end
    iEndListNo = gblListNo
    Call AppendList(2)
End Sub

Public Sub AppendList(iStage As Integer)
    With Debugger
        Select Case iStage
        Case 1:
            .ListIndexAdd = iWhileListNo ' Add List no
            .LetStartPtr
            .ListingAdd Format(iWhileLineNo, "0000 ")
            .ListingAdd Space(gblIndentLvl * gblIndentAmt)
            .ListingAdd "WHILE " & WhileClause.Flush & " DO" & vbCrLf
            .LvlIndent
            .LetLineLen
            
        Case 2:
            .ListIndexAdd = iEndListNo ' Add List No
            .LetStartPtr
            .LvlOutdent
            .ListingAdd "     "        ' No Line No
            .ListingAdd Space(gblIndentLvl * gblIndentAmt)
            .ListingAdd "END" & vbCrLf
            .LetLineLen
        End Select
    End With
End Sub
