VERSION 5.00
Begin VB.Form MainForm 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Simple Interpreter"
   ClientHeight    =   6840
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   8730
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6840
   ScaleWidth      =   8730
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdShowVersion 
      Caption         =   "Show About Window"
      Height          =   435
      Left            =   120
      TabIndex        =   6
      Top             =   6300
      Width           =   1875
   End
   Begin VB.CommandButton cmdExecute 
      Caption         =   "Execute"
      Enabled         =   0   'False
      Height          =   435
      Left            =   7200
      TabIndex        =   5
      Top             =   6300
      Width           =   1335
   End
   Begin VB.ListBox lstLog 
      Height          =   1020
      IntegralHeight  =   0   'False
      Left            =   120
      TabIndex        =   2
      Top             =   5100
      Width           =   8475
   End
   Begin VB.CommandButton cmdParse 
      Caption         =   "Parse"
      Height          =   435
      Left            =   5760
      TabIndex        =   1
      Top             =   6300
      Width           =   1335
   End
   Begin VB.TextBox txtProgram 
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   4215
      Left            =   120
      MultiLine       =   -1  'True
      TabIndex        =   0
      Top             =   420
      Width           =   8475
   End
   Begin VB.Label Label2 
      Caption         =   """Simple"" Program"
      Height          =   255
      Left            =   120
      TabIndex        =   4
      Top             =   120
      Width           =   1755
   End
   Begin VB.Label Label1 
      Caption         =   "Parse Log"
      Height          =   255
      Left            =   120
      TabIndex        =   3
      Top             =   4800
      Width           =   1755
   End
End
Attribute VB_Name = "MainForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Program As Object   'This will point to the tree created by the parser

Private Parser As New GOLDParserEngine.GOLDParser
Private Sub DoParse()
    'This procedure starts the GOLD Parser Engine and handles each of the
    'messages it returns. Each time a reduction is made, a new instance of a
    '"Simple" object is created and stored in the parse tree. The resulting tree
    'will be a pure representation of the Simple language and will be ready to
    'implement.
    
    Dim Response As GOLDParserEngine.GPMessageConstants
    Dim Done As Boolean, Success As Boolean       'Controls when we leave the loop
    Dim Text As String, n As Integer              'Used to create pretty token lists
           
    Success = False    'Unless the program is accepted by the parser
  
    With Parser
        .OpenTextString txtProgram.Text
        .TrimReductions = True
                  
        Done = False
        Do Until Done
            Response = .Parse()
               
            Select Case Response
            Case gpMsgLexicalError
                Log "LEXICAL ERROR. Line " & .CurrentLineNumber & ". Cannot recognize token: " & Parser.CurrentToken.Data
                Done = True
                  
            Case gpMsgSyntaxError
                Text = ""
                For n = 0 To Parser.TokenCount - 1
                    Text = Text & " " & Parser.Tokens(n).Name
                Next
                Log "SYNTAX ERROR. Line " & .CurrentLineNumber & ". Expecting: " & LTrim(Text)
                Done = True
              
            Case gpMsgReduction
                '== Create a new customized object and replace the
                '== CurrentReduction with it. This saves memory and allows
                '== easier interpretation
                Set .CurrentReduction = NewSimpleObject(.CurrentReduction)
                
            Case gpMsgAccept
                '=== Success!
                Set Program = .CurrentReduction
                
                Log "-- Program Accepted --"
                Done = True
                Success = True
              
            Case gpMsgTokenRead
                '=== Do nothing
               
            Case gpMsgInternalError
                Log "INTERNAL ERROR! Something is horribly wrong"
                Done = True
               
            Case gpMsgNotLoadedError
                '=== Due to the if-statement above, this case statement should never be true
                Log "NOT LOADED ERROR! Compiled Grammar Table not loaded"
                Done = True
              
            Case gpMsgCommentError
                Log "COMMENT ERROR! Unexpected end of file"
                Done = True
            
            Case gpMsgCommentBlockRead
                '=== Do nothing
               
            Case gpMsgCommentLineRead
                '=== Do nothing
                              
            End Select
        Loop
    End With
    
    cmdExecute.Enabled = Success
End Sub

Private Sub Log(ByVal Text As String)
   lstLog.AddItem Text
End Sub


Private Sub cmdExecute_Click()
    If Not Program Is Nothing Then
        Program.Execute
    End If
End Sub

Private Sub cmdParse_Click()
    lstLog.Clear
    DoParse
End Sub


Private Sub cmdShowVersion_Click()
    MsgBox Parser.GetAboutText
End Sub

Private Sub Form_Load()
    If Not Parser.LoadCompiledGrammar(App.Path & "\simple 2.cgt") Then
        MsgBox "The CGT file could not be opened!", vbCritical
    End If
End Sub

Private Sub txtProgram_Change()
   cmdExecute.Enabled = False
End Sub


