Attribute VB_Name = "SimpleModule"
Option Explicit

Public Variables As New VariableList

Public Enum SymbolConstants
    SymbolEof = 0            ' (EOF)
    SymbolError = 1          ' (Error)
    SymbolWhitespace = 2     ' (Whitespace)
    SymbolMinus = 3          ' '-'
    SymbolAmp = 4            ' &
    SymbolLparan = 5         ' '('
    SymbolRparan = 6         ' ')'
    SymbolTimes = 7          ' '*'
    SymbolDiv = 8            ' /
    SymbolPlus = 9           ' '+'
    SymbolLt = 10             ' '<'
    SymbolLteq = 11           ' '<'=
    SymbolLtgt = 12           ' '<''>'
    SymbolEq = 13             ' =
    SymbolEqeq = 14           ' ==
    SymbolGt = 15             ' '>'
    SymbolGteq = 16           ' '>'=
    SymbolAssign = 17         ' assign
    SymbolDisplay = 18        ' display
    SymbolDo = 19             ' do
    SymbolElse = 20           ' else
    SymbolEnd = 21            ' end
    SymbolId = 22             ' Id
    SymbolIf = 23             ' if
    SymbolNumberliteral = 24  ' NumberLiteral
    SymbolRead = 25           ' read
    SymbolStringliteral = 26  ' StringLiteral
    SymbolThen = 27           ' then
    SymbolWhile = 28          ' while
    SymbolAddexp = 29         ' <Add Exp>
    SymbolExpression = 30     ' <Expression>
    SymbolMultexp = 31        ' <Mult Exp>
    SymbolNegateexp = 32      ' <Negate Exp>
    SymbolStatement = 33      ' <Statement>
    SymbolStatements = 34     ' <Statements>
    SymbolValue = 35          ' <Value>
End Enum

Enum RuleConstants
    RuleStatements = 0               ' <Statements> ::= <Statement> <Statements>
    RuleStatementsEnd = 1            ' <Statements> ::= <Statement>
    RuleStatementDisplay = 2         ' <Statement> ::= display <Expression>
    RuleStatementDisplayReadId = 3   ' <Statement> ::= display <Expression> read Id
    RuleStatementAssign = 4          ' <Statement> ::= assign Id = <Expression>
    RuleStatementWhile = 5           ' <Statement> ::= while <Expression> do <Statements> end
    RuleStatementIfThen = 6          ' <Statement> ::= if <Expression> then <Statements> end
    RuleStatementIfThenElse = 7      ' <Statement> ::= if <Expression> then <Statements> else <Statements> end
    RuleExpGT = 8                    ' <Expression> ::= <Expression> '>' <Add Exp>
    RuleExpLT = 9                    ' <Expression> ::= <Expression> '<' <Add Exp>
    RuleExpLE = 10                   ' <Expression> ::= <Expression> '<'= <Add Exp>
    RuleExpGE = 11                   ' <Expression> ::= <Expression> '>'= <Add Exp>
    RuleExpEQ = 12                   ' <Expression> ::= <Expression> == <Add Exp>
    RuleExpNEQ = 13                  ' <Expression> ::= <Expression> '<''>' <Add Exp>
    RuleExpEmpty = 14                ' <Expression> ::= <Add Exp>
    RuleExpPlus = 15                 ' <Add Exp> ::= <Add Exp> '+' <Mult Exp>
    RuleExpMinus = 16                ' <Add Exp> ::= <Add Exp> '-' <Mult Exp>
    RuleExpAmp = 17                  ' <Add Exp> ::= <Add Exp> & <Mult Exp>
    RuleAddExpEmpty = 18             ' <Add Exp> ::= <Mult Exp>
    RuleExpTimes = 19                ' <Mult Exp> ::= <Mult Exp> '*' <Negate Exp>
    RuleExpDiv = 20                  ' <Mult Exp> ::= <Mult Exp> / <Negate Exp>
    RuleMultExpEmpty = 21            ' <Mult Exp> ::= <Negate Exp>
    RuleNegateMinus = 22             ' <Negate Exp> ::= '-' <Value>
    RuleNegateEmpty = 23             ' <Negate Exp> ::= <Value>
    RuleValueId = 24                 ' <Value> ::= Id
    RuleValueString = 25             ' <Value> ::= StringLiteral
    RuleValueNumber = 26             ' <Value> ::= NumberLiteral
    RuleValueExpression = 27         ' <Value> ::= '(' <Expression> ')'
End Enum

Public Function CreateSimpleIfStm(IfClause As Object, ThenClause As Object, Optional ElseClause As Object = Nothing) As SimpleIfStm
    Dim Obj As New SimpleIfStm
    
    Set Obj.IfClause = IfClause
    Set Obj.ThenClause = ThenClause
    Set Obj.ElseClause = ElseClause
    
    Set CreateSimpleIfStm = Obj
End Function


Public Function CreateSimpleWhileStm(WhileClause As Object, DoClause As Object) As SimpleWhileStm
    Dim Obj As New SimpleWhileStm
    
    Set Obj.WhileClause = WhileClause
    Set Obj.DoClause = DoClause
        
    Set CreateSimpleWhileStm = Obj
End Function



Public Function CreateSimpleStmList(CurrentStm As Object, Optional NextStm As Object = Nothing) As SimpleStmList
    Dim Obj As New SimpleStmList
    
    Set Obj.CurrentStm = CurrentStm
    ' currentstm is nothing
    If Not NextStm Is Nothing Then
        Set Obj.NextStm = NextStm
    End If
            
    Set CreateSimpleStmList = Obj
End Function



Public Function CreateSimpleID(Name As String) As SimpleID
    Dim Obj As New SimpleID
    
    Obj.Name = Name
    
    Set CreateSimpleID = Obj
End Function

Public Function NewSimpleObject(TheReduction As GOLDParserEngine.Reduction) As Object

    Dim Text As String

    With TheReduction
        Select Case .ParentRule.TableIndex
        Case RuleStatements               ' <Statements> ::= <Statement> <Statements>
            Set NewSimpleObject = CreateSimpleStmList(.Tokens(0).Data, .Tokens(1).Data)
        
        Case RuleStatementsEnd            ' <Statements> ::= <Statement>
            Set NewSimpleObject = CreateSimpleStmList(.Tokens(0).Data)
        
        Case RuleStatementDisplay         ' <Statement> ::= display <Expression>
            Set NewSimpleObject = CreateSimpleDisplayStm(.Tokens(1).Data)
        
        Case RuleStatementDisplayReadId   ' <Statement> ::= display <Expression> read Id
            Set NewSimpleObject = CreateSimpleDisplayStm(.Tokens(1).Data, .Tokens(3).Data)
        
        Case RuleStatementAssign          ' <Statement> ::= assign Id = <Expression>
            Set NewSimpleObject = CreateSimpleAssignStm(.Tokens(1).Data, .Tokens(3).Data)
                
        Case RuleStatementWhile           ' <Statement> ::= while <Expression> do <Statements> end
            Set NewSimpleObject = CreateSimpleWhileStm(.Tokens(1).Data, .Tokens(3).Data)
            
        Case RuleStatementIfThen          ' <Statement> ::= if <Expression> then <Statements> end
            Set NewSimpleObject = CreateSimpleIfStm(.Tokens(1).Data, .Tokens(3).Data)
        
        Case RuleStatementIfThenElse      ' <Statement> ::= if <Expression> then <Statements> else <Statements> end
            Set NewSimpleObject = CreateSimpleIfStm(.Tokens(1).Data, .Tokens(3).Data, .Tokens(5).Data)
                            
        Case RuleExpGT, RuleExpLT, RuleExpLE, RuleExpGE, RuleExpEQ, RuleExpNEQ, _
             RuleExpPlus, RuleExpMinus, RuleExpAmp, RuleExpTimes, RuleExpDiv
             
            Set NewSimpleObject = CreateSimpleExpression(.Tokens(0).Data, .Tokens(1).Data, .Tokens(2).Data)
             
        Case RuleNegateMinus              ' <Negate Exp> ::= '-' <Value>
        
        '=== Since TrimReductions is set to true, none of these reductions will be
        '=== returned. They are performed 'behind the scenes'
        'Case RuleExpEmpty                 ' <Expression> ::= <Add Exp>
        'Case RuleAddExpEmpty              ' <Add Exp> ::= <Mult Exp>
        'Case RuleMultExpEmpty             ' <Mult Exp> ::= <Negate Exp>
        'Case RuleNegateEmpty              ' <Negate Exp> ::= <Value>
        
        Case RuleValueId                  ' <Value> ::= Id
            Variables.Add .Tokens(0).Data
            Set NewSimpleObject = CreateSimpleID(.Tokens(0).Data)
            
        Case RuleValueString              ' <Value> ::= StringLiteral
            Text = .Tokens(0).Data
            If Len(Text) >= 2 Then    'Remove single quotes
                Text = Mid(Text, 2, Len(Text) - 2)
            End If
        
            Set NewSimpleObject = CreateSimpleString(Text)
            
        Case RuleValueNumber              ' <Value> ::= NumberLiteral
            Set NewSimpleObject = CreateSimpleNumber(Val(.Tokens(0).Data))
            
        Case RuleValueExpression          ' <Value> ::= '(' <Expression> ')'
            Set NewSimpleObject = .Tokens(1).Data
        
        End Select
    End With

End Function
Public Function CreateSimpleExpression(LeftOperand As Object, Operator As String, RightOperand As Object) As SimpleExpression
    Dim Obj As New SimpleExpression
    
    Set Obj.LeftOperand = LeftOperand
    Obj.Operator = Operator
    Set Obj.RightOperand = RightOperand
    
    Set CreateSimpleExpression = Obj
End Function



Public Function CreateSimpleString(Text As String) As SimpleString
    Dim Obj As New SimpleString
    
    Obj.Value = Text
        
    Set CreateSimpleString = Obj
End Function

Public Function CreateSimpleDisplayStm(DisplayClause As Object, Optional ReadID As String = "") As SimpleDisplayStm
    Dim Obj As New SimpleDisplayStm

    Set Obj.DisplayClause = DisplayClause
    Obj.ReadID = ReadID
        
    Set CreateSimpleDisplayStm = Obj
End Function



Public Function CreateSimpleAssignStm(Name As String, AssignValue As Object) As SimpleAssignStm
    Dim Obj As New SimpleAssignStm

    Obj.Name = Name
    Set Obj.AssignValue = AssignValue
    
    Set CreateSimpleAssignStm = Obj
End Function




Public Function CreateSimpleNumber(Value As Double) As SimpleNumber
    Dim Obj As New SimpleNumber
    
    Obj.Value = Value
        
    Set CreateSimpleNumber = Obj
End Function


